//**********************************************************************************************
//* Mail Reader Example.
//* --------------------
//*	Demonstrates: 
//*					- WebMail EMail/POP3/SMTP/IMAP encapsulation classes.
//* 				- simlpe multithreading.
//*					- serialization.
//*				
//* Currently, only POP3 class is implemented.
//*

#ifndef _MailReader_MailReader_h
#define _MailReader_MailReader_h

#include <CtrlLib/CtrlLib.h>
#include <WebMail/WebMail.h>

using namespace Upp;

#define LAYOUTFILE <MailReader/MailReader.lay>
#include <CtrlCore/lay.h>

#define IMAGEFILE <MailReader/MailReader.iml>
#define IMAGECLASS MailImages 
#include <Draw/iml_header.h>

class MailReader : public WithMailReaderLayout<TopWindow> {
public:
	typedef MailReader CLASSNAME;

	void		MainMenu(Bar& bar);
	void		FileMenu(Bar& bar);
	void		HelpMenu(Bar& bar);

	void		SetToolBar(Bar& bar);

	void		ReadInbox();
	void		ReadMail();
	void		About();
	void		Settings();
	void		Console	();
	void		ShowMail(EMail& mail, String& log);
	void		ShowInbox(Vector<EMail>& inbox, String& log);
	void		Log(String& s, bool error = false);										

	void		Serialize(Stream& s);

	volatile Atomic terminated;
	volatile Atomic threads;	

	Vector<EMail>	mailbox;
	
private:
	WithSettingsLayout<TopWindow> 	sdlg;
	WithConsoleLayout<TopWindow>	cdlg;
	WithMailViewLayout<TopWindow>	mdlg;
	
	MenuBar		menu;
	ToolBar		tool;
	POP3Mail	pop3;
	
public:
	MailReader();
	~MailReader();
};

//* Multithreading communication structure (eg. (GUI)MailReader<->(thread)InboxReaderThread)
struct MessageInfo {
	String 	host;
	int		port;
	String 	user; 
	String	pass;
	bool	full;
	bool 	transcript;
	int		ssl; 
	bool	apop;
	int		index;
	MailReader*	 gui;
};
#endif

